<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Class Registro controlador encargado de gestionar el registro del usuario del rol delegado
 */
class Registro extends CI_Controller {

    function __construct()
    {
        parent::__construct();
    }

    /**
     *  Funcion para controlar el cambio de la contraseña del usuario con rol de delegado. Muestra
     * los campos necesarios para poder cambiar la contraseña
     */
    public function recoveryPassword()
    {
        if(isset($_GET['token']) && isset($_GET['email'])) {
            $email = $_GET['email'];
            $token = $_GET['token'];

            $this -> load -> model('delegadoModel');
            if($this -> delegadoModel -> existsEmail($email)) {
                if($this -> delegadoModel -> validateToken($token,$email)) {
                    $text = $this ->get_text_recovery_password($this -> session -> userdata('language'));
                    $this->load->view('Estructura/header_styles');
                    $this->load->view('Registro/recovery_password',$text);
                    $this->load->view('Estructura/footer');
                }
                else{
                    // implementacion futura si el token a expirado ..
                    redirect(base_url(), 'refresh');
                }

            }
            else{
                redirect(base_url(), 'refresh');
            }



        }
    }

    /**
     *Funcion controladora del cambio de contraseña del usuario con rol de delegado
     */
    public function changePassword()
    {
        if (isset($_GET['email'])) {
            $email = $_GET['email'];
            $password = password_hash($this->input->post('password1'), PASSWORD_BCRYPT);
            $this->load->model('delegadoModel');
            $this->delegadoModel->setPassword($password, $email);
            redirect(base_url().'?msg='.SUCCESFULL_CHANGE_PASSWORD, 'refresh');
        }
        else {
            redirect(base_url().'?msg='.SESSION_EXPIRED, 'refresh');
        }

    }
    private function get_text_recovery_password($idiom) {
        $this->lang->load('forget_password_lang',$idiom);
        $data['msg_enter_new_password'] = $this->lang->line('msg_enter_new_password');
        $data['msg_repeat_password'] = $this->lang->line('msg_repeat_password');
        $data['btn_change_password'] = $this->lang->line('btn_change_password');

        $data['msg_equal_password'] = $this->lang->line('msg_equal_password');

        return $data;
    }

}
